/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.pdraw.action;

import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.ApplicationSurface;
import DE.siemens.ad.logo.app.FileType;
import DE.siemens.ad.logo.app.action.LogoAction;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.comm.TcpSocketDataTransfer;
import DE.siemens.ad.logo.comm.TransmissionFailedException;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.DataLogParameter;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.DataLogBlock;
import DE.siemens.ad.logo.util.ExceptionAlreadyHandledException;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Log;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.ProgramException;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import java.awt.Window;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class UploadDatalogAction
extends LogoAction {
    private static final long serialVersionUID = -5620919125365140369L;
    private static final String CHARSET_CSV = "UTF-8";
    private static final byte[] CHARSET_HEAD = new byte[]{-17, -69, -65};
    private int dataLogItemLength = 0;
    private int maxItemNumber = 0;
    protected final int ADR_DATALOG_START = 520;
    protected final int DATALOG_LENGTH = 4096;

    public UploadDatalogAction() {
        this.putValue("Name", "UploadDatalog...");
        this.putValue("textKey", "extra.transfer.uploadDatalog");
        this.putValue("SmallIcon", this.getPlaceholder());
        this.disabledContextVector = Collections.singletonList(OnlineTestTool.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doIt() {
        Window window = ((LogoComfort)this.getOwner()).getApplicationSurface().getWindow();
        DataTransfer dt = null;
        try {
            dt = DataTransfer.openConnection(true);
            if (!dt.isTransmissionPossible(window)) {
                throw new ExceptionAlreadyHandledException();
            }
            String ipStr = ((TcpSocketDataTransfer)dt).getRemoteAddress();
            File dataLogFile = this.getDataLogFile(ipStr);
            if (dataLogFile == null) {
                boolean bl = true;
                return bl;
            }
            int result = ((TcpSocketDataTransfer)dt).uploadDataLogData(dataLogFile);
            if (result == 0) {
                new LogoError(window, "extra.transfer.datalogNoDataLogFound", "No data log found", 1).display();
            } else if (result == 2) {
                Log.println(Language.getString("extra.transfer.datalogSuccessfullyUploadedFromSDCard", "Data log is successfully uploaded from SD card."));
            } else if (result == 1) {
                this.uploadDataLogFromBM(dt, dataLogFile);
                Log.println(Language.getString("extra.transfer.datalogSuccessfullyUploadedFromBM", "Data log is successfully uploaded from BM."));
            } else if (result == -1) {
                new LogoError(window, "extra.transfer.datalogUploadFailed", "Failed to upload data log.", 0).display();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (dt != null) {
                dt.closePort();
                dt = null;
            }
        }
        return true;
    }

    private void uploadDataLogFromBM(DataTransfer dt, File dataLogFile) throws ProgramException, ExceptionAlreadyHandledException {
        Hardware hw = dt.getHardware();
        ParameterItemList datalogParameterItemList = null;
        int[] arr = null;
        if (hw.supports("DataLog") && hw.supports("readFunctionParameter")) {
            WiringDiagram wd = null;
            wd = hw.uploadProgram(dt);
            ArrayList<Block> blockList = new ArrayList<Block>();
            Enumeration allBlocks = wd.getBlocks().elements();
            while (allBlocks.hasMoreElements()) {
                Block block = (Block)allBlocks.nextElement();
                if (!(block instanceof DataLogBlock)) continue;
                blockList.add(block);
            }
            DataLogBlock datalogBlock = (DataLogBlock)blockList.get(0);
            datalogParameterItemList = ((DataLogParameter)datalogBlock.getParameter()).getParameterItemList();
            try {
                arr = dt.readByteArray(520, 4096);
            }
            catch (TransmissionFailedException e) {
                e.printStackTrace(System.out);
            }
            this.dataLogItemLength = 8 + 4 * datalogParameterItemList.size();
            this.maxItemNumber = 4093 / this.dataLogItemLength;
            this.saveDatalogAsCSV(dataLogFile, arr, datalogParameterItemList);
        }
    }

    private File getDataLogFile(String ipString) {
        boolean fileNameCorrect;
        FileType csvFileType = FileType.getFileType("csv", Language.getString("dialog.fileChooser.csvFile", "Comma-separated value"), null);
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter(csvFileType);
        fileChooser.setMultiSelectionEnabled(false);
        File modelFile = new File(this.getDataLogFileName(ipString));
        fileChooser.setSelectedFile(modelFile);
        ApplicationSurface surface = Application.getInstance().getActiveApplicationSurface();
        File selectedFile = null;
        do {
            fileNameCorrect = true;
            int rw = fileChooser.showSaveDialog(surface);
            selectedFile = fileChooser.getSelectedFile();
            if (rw == 1 || selectedFile == null) {
                selectedFile = null;
                break;
            }
            String fileName = selectedFile.getName();
            if (fileName.indexOf(".") == -1 || !fileName.toLowerCase().endsWith(".csv")) {
                selectedFile = new File(selectedFile.getPath() + "." + "csv");
            }
            if (selectedFile.exists()) {
                int overwriteRw = JOptionPane.showConfirmDialog(surface, Language.getString("msg.overwriteDocument", "File '%' already exists. Overwrite it?", selectedFile.getName()), Application.getName(), 1);
                if (overwriteRw == 2) {
                    selectedFile = null;
                    break;
                }
                if (overwriteRw == 1) {
                    fileNameCorrect = false;
                    continue;
                }
            }
            if (!fileNameCorrect || !selectedFile.exists() || selectedFile.canWrite()) continue;
            fileNameCorrect = false;
            JOptionPane.showMessageDialog(surface, Language.getString("msg.writeAsProtection", "A write protected file with the same name exists. \nPlease choose another name."), Language.getString("app.name.long", "LOGO!Soft Comfort"), 1);
        } while (!fileNameCorrect);
        return selectedFile;
    }

    private String getDataLogFileName(String ipString) {
        Calendar cal = Calendar.getInstance();
        int year = cal.get(1);
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(10);
        int minute = cal.get(12);
        int second = cal.get(13);
        return ipString + "_" + year + "-" + month + "-" + day + " " + hour + "-" + minute + "-" + second;
    }

    private String getStringForValue(int[] arr, int i, ParameterItemList parameterItemList) {
        StringBuffer valueStr = new StringBuffer();
        int valueIndex = 8;
        for (int j = 0; j < parameterItemList.size(); ++j) {
            int actualValue = Util.makeDoubleWord(arr[i * this.dataLogItemLength + valueIndex++], arr[i * this.dataLogItemLength + valueIndex++], arr[i * this.dataLogItemLength + valueIndex++], arr[i * this.dataLogItemLength + valueIndex++]);
            ParameterItem parameterItem = (ParameterItem)parameterItemList.get(j);
            Block block = parameterItem.getParameter().getBlock();
            int blockNumber = block.getNumber();
            int blockType = block.getNumberType();
            if (blockType == 6 || blockType == 7) {
                actualValue &= 0xFF;
                for (int k = 0; k < 8; ++k) {
                    valueStr.append("," + String.valueOf(actualValue & 1));
                    actualValue >>= 1;
                }
                continue;
            }
            if (blockType == 10) {
                actualValue &= 0xFF;
                int bitNumber = 8;
                if (blockNumber == 25) {
                    bitNumber = 3;
                }
                for (int k = 0; k < bitNumber; ++k) {
                    valueStr.append("," + String.valueOf(actualValue & 1));
                    actualValue >>= 1;
                }
                continue;
            }
            valueStr.append("," + String.valueOf(actualValue));
        }
        return valueStr.toString();
    }

    private String getStringForTime(int[] arr, int i) {
        return String.valueOf(arr[i * this.dataLogItemLength + 1]) + "/" + String.valueOf(arr[i * this.dataLogItemLength]) + "/" + String.valueOf(arr[i * this.dataLogItemLength + 2]) + " " + String.valueOf(arr[i * this.dataLogItemLength + 5]) + ":" + String.valueOf(arr[i * this.dataLogItemLength + 4]) + ":" + String.valueOf(arr[i * this.dataLogItemLength + 3]);
    }

    private String getDataLogTitle(ParameterItemList parameterItemList) {
        StringBuffer title = new StringBuffer("Time");
        for (int i = 0; i < parameterItemList.size(); ++i) {
            int j;
            ParameterItem parameterItem = (ParameterItem)parameterItemList.get(i);
            Block block = parameterItem.getParameter().getBlock();
            int blockType = block.getNumberType();
            String blockNumberPrefix = block.getNumberPrefix();
            int blockNumber = block.getNumber();
            String parameterName = parameterItem.getIdentifier();
            if (blockType == 6 || blockType == 7) {
                for (j = 0; j < 8; ++j) {
                    title.append("," + blockNumberPrefix + blockNumber);
                    ++blockNumber;
                }
                continue;
            }
            if (blockType == 10) {
                if (blockNumber == 25) {
                    title.append("," + blockNumberPrefix + 25 + "," + blockNumberPrefix + 26 + "," + blockNumberPrefix + 27);
                    continue;
                }
                for (j = 0; j < 8; ++j) {
                    title.append("," + blockNumberPrefix + blockNumber);
                    ++blockNumber;
                }
                continue;
            }
            if (blockType == 0 || blockType == 25) {
                title.append("," + blockNumberPrefix + blockNumber + "." + parameterName);
                continue;
            }
            title.append("," + blockNumberPrefix + blockNumber);
        }
        return title.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveDatalogAsCSV(File selectedFile, int[] arr, ParameterItemList parameterItemList) {
        int fIsFull = arr[4093];
        int ItemCount = 0;
        if (this.dataLogItemLength != 0) {
            ItemCount = (arr[4095] << 8 | arr[4094]) / this.dataLogItemLength;
        }
        if (ItemCount > this.maxItemNumber) {
            ItemCount = this.maxItemNumber;
        }
        int datalogItemCount = fIsFull == 0 ? ItemCount : this.maxItemNumber;
        FileOutputStream os = null;
        OutputStreamWriter fFileWriter = null;
        try {
            os = new FileOutputStream(selectedFile);
            fFileWriter = new OutputStreamWriter((OutputStream)os, CHARSET_CSV);
            ((OutputStream)os).write(CHARSET_HEAD);
            String title = this.getDataLogTitle(parameterItemList);
            fFileWriter.write(title);
            if (fIsFull != 0) {
                String datalogItem;
                int i;
                for (i = ItemCount; i < this.maxItemNumber; ++i) {
                    datalogItem = "\n" + this.getStringForTime(arr, i) + this.getStringForValue(arr, i, parameterItemList);
                    fFileWriter.write(datalogItem);
                    fFileWriter.flush();
                }
                for (i = 0; i < ItemCount; ++i) {
                    datalogItem = "\n" + this.getStringForTime(arr, i) + this.getStringForValue(arr, i, parameterItemList);
                    fFileWriter.write(datalogItem);
                    fFileWriter.flush();
                }
            } else {
                for (int i = 0; i < datalogItemCount; ++i) {
                    String datalogItem = "\n" + this.getStringForTime(arr, i) + this.getStringForValue(arr, i, parameterItemList);
                    fFileWriter.write(datalogItem);
                    fFileWriter.flush();
                }
            }
        }
        catch (IOException ex) {
            Log.println(Language.getString("error.saveFile", "Error saving file: " + selectedFile, selectedFile));
        }
        finally {
            try {
                fFileWriter.close();
                ((OutputStream)os).close();
            }
            catch (IOException ex) {}
        }
    }

    public boolean needsWaitCursor() {
        return true;
    }
}

